from splunklib.searchcommands import dispatch, GeneratingCommand, Configuration, Option
import requests, json, re
from SPARQLWrapper import SPARQLWrapper, JSON
import logging

@Configuration()
class SparqlCommand(GeneratingCommand):
    query = Option(require=False)
    config = Option(require=False, default="default")
    debug = Option(require=False, default="")

    variables = {}

    def __get_data(self, query, config):
        self.logger.debug('query:' + query)
        self.logger.debug('config:' + config)

        conf = self.service.confs["settings"]['config:'+config]
        
        token= ""
        if "accessMethod" in conf:
            if conf["accessMethod"] == "oauth2":
                token_endpoint = conf["token_endpoint"]
                
                if "OAUTH_GRANT_TYPE" in conf:
                    if conf["OAUTH_GRANT_TYPE"] == "client_credentials":
                        client_id = conf["OAUTH_CLIENT_ID"]
                        client_secret = conf["OAUTH_CLIENT_SECRET"]
                        accessData = {
                            'grant_type': 'client_credentials',
                            'client_id': client_id,
                            'client_secret': client_secret
                            }

                    elif conf["OAUTH_GRANT_TYPE"] == "password":
                        client_id = conf["OAUTH_CLIENT_ID"]
                        username = conf["OAUTH_USER"]
                        password = conf["OAUTH_PASSWORD"]
                        accessData = {
                            'grant_type': 'password',
                            'client_id': client_id,
                            'username': username,
                            'password': password
                            }

                    response = requests.post(token_endpoint, data=accessData)
                    # Use the json module to load CKAN's response into a dictionary.
                    response_dict = json.loads(response.text)

                    self.logger.debug('Response:')
                    self.logger.debug(response.text)
                    self.logger.debug(response_dict)

                    token = response_dict['access_token']
                    
                    # self.logger.debug('token:')
                    # self.logger.debug(token)

        endpointRead = conf["endpointRead"]
        self.logger.debug('endpointRead:' + endpointRead)

        sparql = SPARQLWrapper(endpointRead, agent='splunk_eccenca_commands/1.0')
        #sparql = SPARQLWrapper("https://linkedwiki.com/sparql")
        #sparql = SPARQLWrapper("https://query.wikidata.org/sparql")

        if token != "":
            self.logger.debug('WITH TOKEN')
            sparql.addCustomHttpHeader('Authorization', ' Bearer ' + token)

        sparql.setQuery(query)
        sparql.setReturnFormat(JSON)
        results = sparql.query().convert()

        # https://www.w3.org/TR/sparql11-results-json/
        self.variables = results["head"]["vars"]

        for result in results["results"]["bindings"]:
            yield(result)
            #print(result)
            #print(result["label"]["value"])

    def generate(self):
        # self.logger.setLevel(logging.DEBUG)
        
        # Splunk replace the html characters to special characters when it finds "javascript:"
        regex = r"(javascript):"
        subst = r"\1&#58;"

        results = self.__get_data(self.query, self.config)

        for r in results:
            data = {}
           
            result_dict = dict(r)
            for k in  self.variables:
                value = ""
                if k in result_dict:
                    v = result_dict.get(k)
                    if "type" in v:
                        valueType = v.get("type")
                        data[f'{k} type'] = valueType
                        if valueType == "uri":
                            value = v.get("value")
                            #'<link href="'+ v.get("value") +'" target="_blank">' + v.get("value") + '</link>'
                        elif valueType == "bnode":
                            value = v.get("value")
                        else: #literal
                            datatype = ""
                            if "datatype" in v:
                                datatype = v.get("datatype")
                                data[f'{k} datatype'] = datatype
                            if 'http://www.w3.org/2001/XMLSchema#dateTime' == datatype:
                                value = v.get("value")
                                # value = parser.parse(v.get("value")).strftime("%m/%d/%Y, %H:%M:%S")
                                # self.logger.debug("datetime")
                                # self.logger.debug(value)
                            elif 'http://www.w3.org/2001/XMLSchema#date' == datatype:
                                value = v.get("value")
                                # value = parser.parse(v.get("value")).strftime("%m/%d/%Y, %H:%M:%S")
                                # self.logger.debug("date")
                                # self.logger.debug(value)
                            else:
                                value = v.get("value")
                            value = re.sub(regex, subst, value, 0, re.MULTILINE | re.IGNORECASE)

                    data[k] = value
                else:
                    data[k] = None

            data["_raw"] = r
            self.logger.debug(r)
            yield data

dispatch(SparqlCommand, module_name=__name__)
