require([
  // TODO check the dependencies
  'splunkjs/mvc/tableview',
  'splunkjs/mvc/eventsviewerview',
  "splunkjs/mvc/chartview",
  'splunkjs/mvc/searchmanager',
  'splunkjs/mvc',
  'underscore',
  'splunkjs/mvc/simplexml/ready!'
], function (
  TableView,
  EventsViewer,
  ChartView,
  SearchManager,
  mvc,
  _
) {

  var columnHTMLRenderer = TableView.BaseCellRenderer.extend({
    initialize: function (args) {
      // initialize will run once, so we will set up a search and events to be reused.
      this._count = 0
    },
    canRender: function (cell) {
      return _(['html']).contains(cell.field);
    },
    render: function ($td, cell) {
        let div = document.createElement("div");

        // div.classList.add("panel-body","html");
        div.innerHTML = cell.value;

        $td.append(div);
        $td.find("a").on("click", function (e) {
          // Prevent drilldown from redirecting away from the page
          e.preventDefault();
          window.open($(this).attr('href'), $(this).attr('target')).focus();
      });
    }
  });

  Object.keys(mvc.Components.attributes).forEach(id => {
    if (id.includes('column_html')) {
      try {
        var tableElement = mvc.Components.getInstance(id);
        tableElement.getVisualization(function (tableView) {
          tableView.addCellRenderer(new columnHTMLRenderer());
          tableView.render();
        });
      } catch (e) {
        console.log(e);
      }
    }
  });
});