# Linked Data app

## Configure the app

Copy the file and modify it:

```bash
cp default/settings_template.conf default/settings.conf
vi default/settings.conf
```

You have an example of configuration for the eccenca sandbox SPARQL endpoint in the file `default/settings_template_sandbox.conf` and an other example via Oauth2 secret ID in the file `default/settings_template_oauth_secret_id.conf`.

To add a new public SPARQL endpoint, add these two lines in the file `settings.conf` where your need to replace here `wikidata` by the name of new endpoint and `https://query.wikidata.org/sparql` by the url of endpoint.
```
[config:wikidata]
endpointRead=https://query.wikidata.org/sparql
```

Restart after your Splunk instance to use your new endpoint (here wikidata):
```
| sparql
    config="wikidata"
    query="
        select *
        where {
            ?s ?p ?v
        }
        LIMIT 10
    "
```

## Installation via the repository

### Copy the app in Splunk

Via the files: clone the project `eccenca_commands` in the folder splunk/etc/apps of Splunk.

### Dependencies for Python

Installation of Dependencies:
```bash
    cd eccenca_commands
    pip install sparqlwrapper -t bin
    pip install splunk-sdk  -t bin
```

## Things to know during the development

Refresh the javascript and static Web files with this link:
- http://127.0.0.1:8000/en-US/debug/refresh (local)

To see logs of the sparql-command, you have to enable this line in the code of sparql-command.py:

    # self.logger.setLevel(logging.DEBUG)

After each execution, the command creates a job.log. You can find this file directly in the interface of Splunk, search "job", "inspect job".

To see logs of dashboards (javascript), you need to open the inspect tools of navigator.